/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.common.item;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.PlantType;
import novamachina.exnihilosequentia.common.init.ExNihiloInitialization;

public class SeedBaseItem
extends Item
implements IPlantable {
    @Nonnull
    private final BlockState plant;
    @Nullable
    private PlantType type;

    public SeedBaseItem(@Nonnull BlockState plant, @Nonnull PlantType type) {
        super(new Item.Properties().m_41491_(ExNihiloInitialization.ITEM_GROUP));
        this.plant = plant;
        this.type = type;
    }

    @Nullable
    public BlockState getPlant(@Nonnull BlockGetter world, @Nonnull BlockPos pos) {
        return this.plant;
    }

    @Nullable
    public PlantType getPlantType(@Nonnull BlockGetter world, @Nonnull BlockPos pos) {
        return this.type;
    }

    @Nonnull
    public InteractionResult m_6225_(@Nonnull UseOnContext context) {
        if (!context.m_43719_().equals((Object)Direction.UP)) {
            return InteractionResult.PASS;
        }
        ItemStack item = context.m_43722_();
        Player player = context.m_43723_();
        BlockPos pos = context.m_8083_();
        Direction direction = context.m_43719_();
        Level world = context.m_43725_();
        if (player != null && this.type != null && player.m_36204_(pos, direction, item) && player.m_36204_(pos.m_142082_(0, 1, 0), direction, item)) {
            BlockState soil = this.type == PlantType.WATER ? world.m_8055_(context.m_8083_().m_142082_(0, 1, 0)) : world.m_8055_(context.m_8083_());
            boolean canSustain = soil.m_60734_().canSustainPlant(soil, (BlockGetter)world, pos, Direction.UP, (IPlantable)this);
            boolean blockEmpty = this.isBlockSpaceEmpty(world, pos, this.type);
            BlockState plantAtPos = this.getPlant((BlockGetter)world, pos);
            if (canSustain && blockEmpty && plantAtPos != null) {
                world.m_46597_(pos.m_142082_(0, 1, 0), plantAtPos);
                if (plantAtPos.m_60734_() instanceof DoublePlantBlock) {
                    world.m_46597_(pos.m_6630_(2), (BlockState)plantAtPos.m_61124_((Property)DoublePlantBlock.f_52858_, (Comparable)DoubleBlockHalf.UPPER));
                }
                if (!player.m_7500_()) {
                    item.m_41774_(1);
                }
                world.m_5594_(player, player.m_142538_(), SoundEvents.f_11991_, SoundSource.AMBIENT, 1.0f, 1.0f);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    private boolean isBlockSpaceEmpty(@Nonnull Level world, @Nonnull BlockPos pos, @Nonnull PlantType type) {
        if (type == PlantType.WATER) {
            return world.m_8055_(pos.m_7494_()).m_60734_() == Blocks.f_49990_;
        }
        return world.m_46859_(pos.m_7494_());
    }
}

